import {createUmi} from '@metaplex-foundation/umi-bundle-defaults';
import {walletAdapterIdentity} from '@metaplex-foundation/umi-signer-wallet-adapters';
import {mplCandyMachine, mintV2, fetchCandyMachine} from '@metaplex-foundation/mpl-candy-machine';
import {generateSigner, publicKey} from '@metaplex-foundation/umi';
import type {WalletContextState} from '@solana/wallet-adapter-react';

export async function mintFromCandyMachine(params:{rpcUrl:string;candyMachineId:string;wallet:WalletContextState;}):Promise<{signature:string;nftMint:string}>{
  const {rpcUrl,candyMachineId,wallet}=params;
  if(!wallet.publicKey) throw new Error('Wallet not connected.');
  if(!wallet.signTransaction) throw new Error('Wallet cannot sign transactions.');
  const umi=createUmi(rpcUrl).use(mplCandyMachine());
  umi.use(walletAdapterIdentity(wallet as any));
  const cmPk=publicKey(candyMachineId);
  const candyMachine=await fetchCandyMachine(umi, cmPk);
  const nftMint=generateSigner(umi);
  const {signature}=await mintV2(umi,{
    candyMachine:candyMachine.publicKey,
    nftMint,
    collectionMint:candyMachine.collectionMint,
    collectionUpdateAuthority:candyMachine.authority,
  }).sendAndConfirm(umi,{confirm:{commitment:'confirmed'}});
  return {signature, nftMint: nftMint.publicKey.toString()};
}
export function explorerTx(sig:string){return `https://explorer.solana.com/tx/${sig}`;}
