import {Connection, PublicKey} from '@solana/web3.js';
export async function walletOwnsStandardNft(params:{connection:Connection;wallet:string;nftMint:string}):Promise<boolean>{
  const {connection,wallet,nftMint}=params;
  const mintPk=new PublicKey(nftMint);
  const largest=await connection.getTokenLargestAccounts(mintPk);
  if(largest.value.length===0) return false;
  for(const acct of largest.value){
    if(acct.amount!=='1') continue;
    const info=await connection.getParsedAccountInfo(new PublicKey(acct.address));
    const parsed:any=info.value?.data;
    const owner=parsed?.parsed?.info?.owner as string|undefined;
    const amount=parsed?.parsed?.info?.tokenAmount?.amount as string|undefined;
    if(owner===wallet && amount==='1') return true;
  }
  return false;
}
