# openTILL Identity Mint + opentill.sol Subdomain (NFT-bound)

**Design 1 (recommended):** the server keeps SNS authority, and the *current NFT holder* can claim control of subdomain records
via a signed message. Subdomain is deterministically bound to the NFT mint: `{role}-{mintPrefix}.opentill.sol`.

Repo:
- `/web`: Vite + React mint landing page (Candy Machine v3) + wallet connect + calls API
- `/api`: Node/Express API: nonce, signature verify, NFT ownership check, SNS subdomain create/claim (scaffold)

✅ Works out of the box:
- Mint UI + wallet connect
- Nonce + signed-message verification
- Standard NFT ownership check (SPL token mint supply 1)

⚠️ SNS write ops are scaffolded in `api/src/sns.ts` with TODOs for correct parent domain derivation and record strategy.
You must own `opentill.sol` on SNS and provide the parent authority keypair to the server.

## Local dev
```bash
npm install

# terminal 1
npm run dev:api

# terminal 2
npm run dev
```
