export type Phase='AMBASSADOR'|'MERCHANT'|'CONSUMER';
export const CONFIG={
  rpcUrl:(import.meta.env.VITE_SOLANA_RPC_URL as string)||'https://api.mainnet-beta.solana.com',
  apiBaseUrl:(import.meta.env.VITE_API_BASE_URL as string)||'http://localhost:8787',
  candyMachineId:{
    AMBASSADOR:(import.meta.env.VITE_CM_AMBASSADOR as string)||'REPLACE_WITH_CANDY_MACHINE_ID',
    MERCHANT:(import.meta.env.VITE_CM_MERCHANT as string)||'REPLACE_WITH_CANDY_MACHINE_ID',
    CONSUMER:(import.meta.env.VITE_CM_CONSUMER as string)||'REPLACE_WITH_CANDY_MACHINE_ID',
  } as Record<Phase,string>,
  collectionAddress:(import.meta.env.VITE_COLLECTION as string)||'REPLACE_WITH_COLLECTION_ADDRESS',
  phaseSchedule:{
    AMBASSADOR:{label:'Phase 1: Ambassador',starts:'TBD',ends:'TBD'},
    MERCHANT:{label:'Phase 2: Merchant',starts:'TBD',ends:'TBD'},
    CONSUMER:{label:'Phase 3: Consumer',starts:'TBD',ends:'TBD'},
  } as Record<Phase,{label:string;starts:string;ends:string}>
};
